if (typeof MYAPP === 'undefined') {
    MYAPP = {};
}

MYAPP.utility = (function () {
    function AssertException(message) {
        this.message = message;
    }

    AssertException.prototype.toString = function () {
        return 'AssertException: ' + this.message;
    };

    /**
     * Assert function
     *
     * @param exp expression
     * @param message optional message for assertion failed
     */
    var assert = function assert (exp, message) {
        if (!exp) {
            if (console && console.trace) {
                console.trace();
            }

            throw new AssertException(message);
        }
    };

    /**
     * Search manage from scheme
     *
     * @param scheme the scheme object
     * @param pageId page ID
     * @return object of mange if found
     */
    var myInnManage = function (scheme, pageId) {

        var getManage = function (pageId) {
            var result = {},
                obj,
                arr,
                i;

            if (scheme.pageId[pageId + '.htm']) {

                arr = scheme.pageId[pageId + '.htm'].arr;

                obj = scheme;

                for (i = 0; i < arr.length; i += 1) {
                    if (obj.step ||
                            !obj[arr[i]]) {
                        break;
                    }

                    obj = obj[arr[i]];
                }

                assert(obj.step);
                assert(obj.defaultStep);

                result.step = obj.step;
                result.stepItem = obj.defaultStep;

                // step | action
                if (i < arr.length) {
                    if (obj.step) {

                        if (obj.step[arr[i]]) {

                            result.stepItem = obj.step[arr[i]];

                            obj = obj.step[arr[i]];

                            i += 1;
                        }
                    }
                }

                if (result.stepItem) {
                    result.action = result.stepItem.action;
                }

                if (i < arr.length) {
                    if (obj.action) {

                        if (obj.action[arr[i]]) {

                            result.action = obj.action[arr[i]];

                            i += 1;
                        }
                    }
                }

                assert(i === arr.length);

            }

            return result;
        };

        var manage,
            result = {
                stepOpList: '',
                step: '',
                actOpList: '',
                act: ''
            },
            i,
            stepItem,
            actionItem;

        manage = getManage(pageId);

        if (!manage.step ||
                !manage.stepItem ||
                !manage.action) {

            return result;
        }

        if (manage.step.list.length > 1) {
            for (i = 0; i < manage.step.list.length; i += 1) {
                stepItem = manage.step.list[i];
    
                if (!stepItem.name) {
                    continue;
                }
    
                result.stepOpList += ((i !== 0) ? '?' : '') + (i + 1) + '. ' + stepItem.name;
    
                if (manage.stepItem.name === stepItem.name) {
                    result.step = (i + 1) + '. ' + stepItem.name;
                }
            }
        }
        
        if (manage.action.list.length > 1) {
            if (!manage.action.defaultValue) {
                if (manage.action.list[0].name) {
                    manage.action.defaultValue = manage.action.list[0].name;
                }
                else {
                    manage.action.defaultValue = '';
                }
            }

            for (i = 0; i < manage.action.list.length; i += 1) {
                actionItem = manage.action.list[i];

                if (!actionItem.name) {
                    continue;
                }

                result.actOpList += ((i !== 0) ? '?' : '') + actionItem.name;

                if (manage.action.defaultValue === actionItem.name) {
                    result.act = actionItem.name;
                }
            }
        }

        return result;
    };

    /**
     * Create menu commands
     *
     * @param scheme the scheme object
     * @return array of menu command
     */
    var myMenu = function (scheme) {

        var createAddItemCommand = function (level, prefix, menuItem) {
            var getQuery = function (action) {
                var length = 0,
                    name;

                if (action.useTransferPage &&
                        action.useTransferPage === true) {
                    return 'first';
                }

                if (action.parameters) {
                    for (name in action.parameters) {

                        if (!action.parameters.hasOwnProperty(name)) {
                            continue;
                        }

                        length += 1;
                    }
                }

                if (length === 1 && action.parameters.unit) {
                    return 'unit';
                }

                return 'no';

            };

            var menuName = menuItem.name,
                step = menuItem.step,
                manage = 'no',
                pageUrl = '',
                query = 'no',
                i,
                j,
                stepItem,
                actionItem;

            if (1 < step.list.length) {
                manage = 'yes';
            }
            else if (1 === step.list.length) {
                stepItem = step.list[0];

                if (1 < stepItem.action.list.length) {
                    manage = 'yes';
                }
            }

            for (i = 0; i < step.list.length; i += 1) {
                stepItem = step.list[i];

                if ((step.defaultValue &&
                        step.defaultValue === stepItem.name) ||
                        (!step.defaultValue)) {

                    for (j = 0; j < stepItem.action.list.length; j += 1) {
                        actionItem = stepItem.action.list[j];

                        if ((stepItem.action.defaultValue &&
                                stepItem.action.defaultValue === actionItem.name) ||
                                (!stepItem.action.defaultValue)) {

                            pageUrl = actionItem.pageUrl;

                            query = getQuery(actionItem);

                            break;
                        }

                    }

                    break;
                }
            }

            return {
                command: 'addItem',
                parameters: [
                    level,
                    prefix + menuName,
                    'no',
                    menuName,
                    pageUrl,
                    manage,
                    query
                ]
            };

        };

        var result_menu = [],
            l1,
            l2,
            l3,
            command;

        for (l1 = 0; l1 < scheme.list.length; l1 += 1) {
            //console.log("l1 : " + scheme.list[l1].name );

            if (!scheme.list[l1].list ||
                    0 === scheme.list[l1].list.length) {

                command = createAddItemCommand(1,
                            '',
                            scheme.list[l1]);

                result_menu.push(command);

                continue;
            }

            if (0 === scheme.list[l1].list.length) {

                result_menu.push({
                    command: 'addItem',
                    parameters: [
                        1,
                        scheme.list[l1].name,           // Interface
                        'no',
                        scheme.list[l1].name,           // Interface
                        '#',
                        'no',
                        'no'
                    ]
                });

                continue;
            }

            result_menu.push({
                command: 'addItem',
                parameters: [
                    1,
                    scheme.list[l1].name,           // Interface
                    scheme.list[l1].name + 'List',  // Interface List
                    scheme.list[l1].name,           // Interface
                    '#',
                    'no',
                    'no'
                ]
            });

            result_menu.push({
                command: 'startL',
                parameters: [
                    scheme.list[l1].name + 'List'   // Interface List
                ]
            });

            for (l2 = 0; l2 < scheme.list[l1].list.length; l2 += 1) {
                //console.log("  l2 : " + scheme.list[l1].list[l2].name );

                if (!scheme.list[l1].list[l2].list ||
                        0 === scheme.list[l1].list[l2].list.length) {

                    command = createAddItemCommand(2,
                                scheme.list[l1].name + '_',
                                scheme.list[l1].list[l2]);

                    result_menu.push(command);

                    continue;
                }

                result_menu.push({
                    command: 'addItem',
                    parameters: [
                        2,
                        scheme.list[l1].name + '_' + scheme.list[l1].list[l2].name,          // Interface _ Port
                        scheme.list[l1].name + '_' + scheme.list[l1].list[l2].name + 'List', // Interface _ Port List
                        scheme.list[l1].list[l2].name,
                        '#',
                        'no',
                        'no'
                    ]
                });

                result_menu.push({
                    command: 'startL',
                    parameters: [
                        scheme.list[l1].name + '_' + scheme.list[l1].list[l2].name + 'List' // Interface _ Port List
                    ]
                });

                for (l3 = 0; l3 < scheme.list[l1].list[l2].list.length; l3 += 1) {
                    //console.log("    l3 : " + scheme.list[l1].list[l2].list[l3].name );

                    command = createAddItemCommand(3,
                                scheme.list[l1].name + '_' + scheme.list[l1].list[l2].name + '_',
                                scheme.list[l1].list[l2].list[l3]);

                    result_menu.push(command);
                }

                result_menu.push({
                    command: 'endL',
                    parameters: []
                });

            }

            result_menu.push({
                command: 'endL',
                parameters: []
            });
        }

        return result_menu;

    };

    // Find by pageId > step > default action
    var getStepAction = function (scheme, query) {

        var getStep = function (scheme, query) {

            var arr,
                obj,
                i,
                cookie;

            assert(scheme);
            assert(scheme.each);

            assert(query.pageId);
            assert(query.step);

            if (scheme.pageId[query.pageId + '.htm']) {

                arr = scheme.pageId[query.pageId + '.htm'].arr;

                obj = scheme;

                for (i = 0; i < arr.length; i += 1) {
                    if (obj.step ||
                            !obj[arr[i]]) {
                        break;
                    }

                    obj = obj[arr[i]];
                }

                assert(obj.step);

                cookie = {
                    pageId: query.pageId
                };

                cookie.stepName = query.step.replace(/\d+. /, '');

                scheme.each(obj, cookie, function (node, cookie) {

                    if (node.name && node.name === cookie.stepName) {
                        cookie.stepItem = node;
                    }

                    if (node.pageUrl &&
                            node.pageUrl === (cookie.pageId + '.htm')) {
                        cookie.found = cookie.stepItem;
                        return;
                    }

                });

                assert(cookie.found);

                return cookie.found;
            }

            return undefined;
        };

        var step = getStep(scheme, query),
            i;

        if (!step) {
            return undefined;
        }

        for (i = 0; i < step.action.list.length; i += 1) {

            if ((step.action.defaultValue &&
                    step.action.defaultValue === step.action.list[i].name) ||
                    (!step.action.defaultValue)) {
                return step.action.list[i];
            }

        }

        return undefined;
    };

    // Find by sidebar > step | action
    var getAction = function (scheme, query) {
        var level,
            obj,
            stepName;

        obj = scheme;

        for (level = 0; level < query.sidebar.length; level += 1) {

            if (!obj[query.sidebar[level]]) {
                return undefined;
            }

            obj = obj[query.sidebar[level]];
        }

        if (query.step) {
            stepName = query.step.replace(/\d+. /, '');

            obj = obj.step[stepName];
        }
        else {
            obj = obj.defaultStep;
        }

        if (!obj) {
            return undefined;
        }

        if (query.action) {
            obj = obj.action[query.action];
        }
        else {
            obj = obj.defaultAction;
        }

        return obj;

    };

    var getTransferUrl = function (scheme, query) {
        var action,
            queryStr = '',
            parameter,
            value;

        // Find by pageId > step > default action
        if (query.pageId && query.step) {

            action = getStepAction(scheme, query);
        }
        // Find by sidebar > step | action
        else if (query.sidebar &&
                query.sidebar.length &&
                0 < query.sidebar.length) {

            action = getAction(scheme, query);
        }

        if (!action) {
            return undefined;
        }

        if (action.useTransferPage &&
                action.useTransferPage === true) {
            assert(query.parameters.unit);
            return 'transfer.htm?unit=' + query.parameters.unit + '&pageId=' + action.pageUrl.split('.htm')[0];
        }

/*
        if (query.parameters) {
            for (parameter in action.parameters) {
                if (!action.parameters.hasOwnProperty(parameter)) {
                    continue;
                }

                if (typeof query.parameters[parameter] !== 'undefined') {
                    queryStr += ((queryStr === '') ? '' : '&') + parameter + '=' + query.parameters[parameter];
                }
            }
        }
*/

        for (parameter in action.parameters) {
            if (!action.parameters.hasOwnProperty(parameter)) {
                continue;
            }

            value = undefined;

            if (typeof action.parameters[parameter] !== 'undefined') {
                value = action.parameters[parameter].defaultValue;
            }

            if (typeof value === 'undefined' &&
                    query.parameters) {
                value = query.parameters[parameter];
            }

            if (typeof value !== 'undefined') {
                queryStr += ((queryStr === '') ? '' : '&') + parameter + '=' + value;
            }
        }

        if (queryStr !== '') {
            return action.pageUrl + '?' + queryStr;
        }

        return action.pageUrl;

    };

    return {
        assert: assert,
        myInnManage: myInnManage,
        myMenu: myMenu,
        getTransferUrl: getTransferUrl
    };

}());
